VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "clsPlugin"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = True

' l2uthless Chat Plugin Example
' Please remember that the bot calls the library from the \Plugins\

' The project must be an ActiveX DLL
' The main module name MUST remain clsPlugin

' When the /loadplugin command is executed, the bot calls these 2 following functions in this order:
' RunPlugin(), ProfileSwitch(), AddToMenu()

' Leave the default declerations alone

Option Base 0
Option Explicit
Private BotIndex As Integer
Private MainForm As Object
Private Bot As Object
' Now you can edit

Private Sub Class_Terminate()
    'just freeing the variables
    Set Bot = Nothing
    Set MainForm = Nothing
End Sub

Public Sub RunPlugin(ByVal frmMain As Object, ByRef Info() As String)
    'Main form is the starting form of the bot
    Set MainForm = frmMain
    
    ' You must ReDim the array to the amount of arguments you wish to have
    ' Remember that arrays start at 0
    ReDim Info(2)
    
    Info(0) = "Author: l2k-Shadow"
    Info(1) = "Plugin: l2uthless Chat Plugin Example"
    Info(2) = "Description: Shows how to create plugins for l2uthless Chat"
End Sub

Public Sub AddToUserMenu(ByRef ChildMenus() As String)
' Even if the sub is empty the bot still calls it, so leave it in or the plugin will crash.
    ReDim ChildMenus(3)
    ChildMenus(0) = "Example User Child Menu 1"
    ChildMenus(1) = "Example User Child Menu 2"
    ChildMenus(2) = "Example User Child Menu 3"
    ChildMenus(3) = "-" ' ~ menu with caption dash creates a divider line
End Sub

Public Sub AddToPluginsMenu(ByRef ChildMenus() As String)
' Even if the sub is empty the bot still calls it, so leave it in or the plugin will crash.
    ReDim ChildMenus(3)
    ChildMenus(0) = "Example Plugins Child Menu 1"
    ChildMenus(1) = "Example Plugins Child Menu 2"
    ChildMenus(2) = "Example Plugins Child Menu 3"
    ChildMenus(3) = "-" ' ~ menu with caption dash creates a divider line
End Sub

Public Sub ProfileSwitch(ByVal objBot As Object, ByVal Index As Integer)
' This event will be called when user switches from one profile to another.
' Index is the index of the profile, this is the variable needed for MainForm's indexed controls.
    Set Bot = objBot
    BotIndex = Index
    Bot.AddChat vbGreen, "Hey, you just switched to profile " & Bot.Profile
    ' Call the following to ensure that plugin will not switch it's profile object:
    MainForm.DontSwitchProfiles App.EXEName, True
End Sub

Public Sub MenuClicked(ByVal MenuName As String, Optional ByVal UserClicked As String)
' This event will be called when a plugin menu is clicked.
' Even if the sub is empty the bot still calls it, so leave it in or the plugin will crash.
    Bot.AddChat vbGreen, "Hey, you just clicked menu " & MenuName
End Sub

'Public Function MessageSend(ByVal Index As Integer, ByVal Message As String, Optional ByRef ReturnMessage As String) As Boolean
' The Above format is not yet functional with current l2uthless Chat Version
Public Function MessageSend(ByVal Message As String) As Boolean
' This event will be called when someone inputs a command into the send box.
' Even if the sub is empty the bot still calls it, so leave it in or the plugin will crash.
' If you wish the bot to not continue with sending the message, set MessageSend as True
' If you are planning on using Case Else, make sure to not set MessageSend or you'll fuck the bot over
' until the plugin is unloaded
    ReturnMessage = "Example return message"
    Select Case LCase$(Message)
        Case "/example"
            Bot.AddChat vbRed, "Hey, ", vbGreen, "I just intercepted your example message!"
            MessageSend = True
        Case "/send"
            Bot.Send "Sending example message!"
            MessageSend = True
        Case Else
            Bot.AddChat vbGreen, "Hey, I just intercepted your message " & Message & " but I'm letting it go through!"
    End Select
End Function

Public Sub MessageReceive(ByVal Index As Integer, ByVal EventID As Long, Optional ByVal Username As String, Optional ByVal Message As String, Optional ByVal Ping As Long, Optional ByVal Flags As Long, Optional ByVal Statstring As String)
' This event will be called when something happens on battle.net
' Possible EventIDs are the same as Battle.net's 0x0F IDs
' 0x01 - Users that are in channel when you enter
' 0x02 - When user joins the channel
' 0x03 - When user leaves the channel
' 0x04 - When user whispers you
' 0x05 - When user talks
' 0x07 - When you enter a channel
' 0x09 - When flags are updated for a user
' 0x0A - When you whisper someone
' 0x12 - Information from Battle.net server
' 0x13 - Error from Battle.net server
' 0x17 - When user does /emote
' 0x18 - When user talks with encrypted message (this ID is unique to l2uthless Chat)
    Bot.AddChat vbGreen, "Event: " & "0x" & Hex(EventID) & " from profile #" & Index
End Sub

